package org.nhindirect.config.ui;
/* 
Copyright (c) 2010, NHIN Direct Project
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer 
   in the documentation and/or other materials provided with the distribution.  
3. Neither the name of the The NHIN Direct Project (nhindirect.org) nor the names of its contributors may be used to endorse or promote 
   products derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
THE POSSIBILITY OF SUCH DAMAGE.
*/
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.inject.Inject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.nhindirect.config.service.ConfigurationService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.*;
import org.nhindirect.config.ui.form.AddressForm;
import org.nhindirect.config.ui.form.AnchorForm;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.DomainForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;


@Controller
@RequestMapping("/domain")
public class DomainController {
	
    private final Log log = LogFactory.getLog(getClass());
    
    private ConfigurationService configSvc;
    
    @Inject
    public void setConfigurationService(ConfigurationService service)
    {
        this.configSvc = service;
    }
  
    /*
	@Inject
	private DomainService configSvc;

	@Inject
	private AddressService configSvc;
	
	@Inject
	private configSvc configSvc;
	
	@Inject
	private CertificateService configSvc;
    */

	public DomainController() {
		if (log.isDebugEnabled()) log.debug("DomainController initialized");
	}
	
	private Collection<AnchorForm> convertAnchors(Collection<Anchor> anchors){
		Collection<AnchorForm> form = new ArrayList<AnchorForm>();
		if (anchors != null)
		{
    		for (Iterator iter = anchors.iterator(); iter.hasNext();) {
    			Anchor t = (Anchor) iter.next();
    			AnchorForm e = new AnchorForm();
    			e.setCertificateData(t.getData());
    			e.setCertificateId(t.getCertificateId());
    			e.setCreateTime(t.getCreateTime());
    			e.setId(t.getId());
    			e.setIncoming(t.isIncoming());
    			e.setOutgoing(t.isOutgoing());
    			e.setOwner(t.getOwner());
    			e.setStatus(t.getStatus());
    			e.setThumbprint(t.getThumbprint());
    			e.setValidEndDate(t.getValidEndDate());
    			e.setValidStartDate(t.getValidStartDate());
    
                String theUser = "";
                if (t.getData() != null)
                {
                        // get the owner from the certificate information
                        // first transform into a certificate
                        CertContainer cont;
    					try {
    						cont = toCertContainer(t.getData());
    	                    if (cont != null && cont.getCert() != null)
    	                    {
    	                            // now get the owner info from the cert
    	                            theUser = getTrustedEntityName(cont.getCert().getSubjectX500Principal());
    	                    }
    					} catch (Exception e1) {
    						e1.printStackTrace();
    					}
                }
    			e.setTrusteddomainoruser(theUser);
    			form.add(e);
    		}			
		}	
		return form;
	}
        
        @PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/addBundle", method = RequestMethod.POST)
	public ModelAndView addBundle (
            @RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
            HttpSession session,
            @ModelAttribute AnchorForm anchorForm,
            Model model,
            @RequestParam(value="domainId") String domainId,
            @RequestParam(value="bundles") String bundles
            ) { 		

		ModelAndView mav = new ModelAndView();                 
		
                // DEBUG
                if ( log.isDebugEnabled() ) {
                    log.debug("Enter domain/addBundle");
                }
                
                String[] bundleIds = bundles.split(":");

                for(String bundle : bundleIds) {
                    String[] bundleArray = bundle.split("_");
                    
                    try {
                    
                        if(bundleArray[1].equals("both")) {
                            configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), Integer.parseInt(bundleArray[0]), true, true);
                        } else if (bundleArray[1].equals("in")) {
                            configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), Integer.parseInt(bundleArray[0]), true, false);
                        } else if (bundleArray[1].equals("out")) {
                            configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), Integer.parseInt(bundleArray[0]), false, true);
                        } else {
                            configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), Integer.parseInt(bundleArray[0]), false, false);
                        }
                    } catch (ConfigurationServiceException cse) {
                        
                    }
                    
                }
                
                return new ModelAndView("redirect:/config/domain?id="+domainId+"&action=update#tab3");
                
        }
        
        @PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/removeBundles", method = RequestMethod.POST)
	public ModelAndView removeBundles (
            @RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
            HttpSession session,
            @ModelAttribute AnchorForm anchorForm,
            Model model,
            @RequestParam(value="domainId") String domainId,
            @RequestParam(value="bundles") String bundles
            ) { 		

		ModelAndView mav = new ModelAndView();                 
		
                // DEBUG
                if ( log.isDebugEnabled() ) {
                    log.debug("Enter domain/removeBundles");
                }
                
                String[] bundleIds = bundles.split(":");

                for(String bundle : bundleIds) {
                    
                    
                    try {
                    
                        configSvc.disassociateTrustBundleFromDomain(Long.parseLong(domainId), Long.parseLong(bundle));
                        
                    } catch (ConfigurationServiceException cse) {
                        
                    }
                    
                }
                
                return new ModelAndView("redirect:/config/domain?id="+domainId+"&action=update#tab3");
                
        }
	
	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/addanchor", method = RequestMethod.POST)
	public ModelAndView addAnchor (
								@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute AnchorForm anchorForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath
						        ) { 		

		ModelAndView mav = new ModelAndView(); 
		String strid = "";
		if (log.isDebugEnabled()) log.debug("Enter domain/addanchor");
		
		if(actionPath.equalsIgnoreCase("newanchor") || actionPath.equalsIgnoreCase("add anchor")){
			strid = ""+anchorForm.getId();
			Domain dom = configSvc.getDomain(Long.parseLong(strid));
			String owner = "";
			if(dom != null){
				owner = dom.getDomainName();
			}
			// insert the new address into the Domain list of Addresses
			EntityStatus estatus = anchorForm.getStatus();
			if (log.isDebugEnabled()) log.debug("beginning to evaluate filedata");		
			try{
				if (!anchorForm.getFileData().isEmpty()) {
					byte[] bytes = anchorForm.getFileData().getBytes();
                   String theUser = "";
                    if (bytes != null)
                    {
                            // get the owner from the certificate information
                            // first transform into a certificate
                            CertContainer cont = toCertContainer(bytes);
                            if (cont != null && cont.getCert() != null)
                            {
                                    // now get the owner info from the cert
                                    theUser = getTrustedEntityName(cont.getCert().getSubjectX500Principal());
                                    anchorForm.setTrusteddomainoruser(theUser);
                            }
                    }

					// store the bytes somewhere
					Anchor ank = new Anchor();
					ank.setData(bytes);
					if (log.isDebugEnabled()) log.debug("incoming is: "+anchorForm.isIncoming()+" and outgoing is: "+anchorForm.isOutgoing());
					ank.setIncoming(anchorForm.isIncoming());
					ank.setOutgoing(anchorForm.isOutgoing());
					ank.setOwner(owner);
					ank.setStatus(anchorForm.getStatus());

					ArrayList<Anchor> anchorlist = new ArrayList<Anchor>();
					anchorlist.add(ank);
					
					configSvc.addAnchors(anchorlist);
					if (log.isDebugEnabled()) log.debug("store the anchor certificate into database");
				} else {
					if (log.isDebugEnabled()) log.debug("DO NOT store the anchor certificate into database BECAUSE THERE IS NO FILE");
				}

			} catch (ConfigurationServiceException ed) {
				if (log.isDebugEnabled())
					log.error(ed);
			} catch (Exception e) {
				if (log.isDebugEnabled()) log.error(e.getMessage());
				e.printStackTrace();
			}
			// certificate and anchor forms and results
			try {
				Collection<Certificate> certs = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
				model.addAttribute("certificatesResults", certs);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			try {
				 
				Collection<Anchor> anchors = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
				// convert Anchor to AnchorForm
				Collection<AnchorForm> convertedanchors = convertAnchors(anchors);					
				// now set anchorsResults
				model.addAttribute("anchorsResults", convertedanchors);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			try {
				CertificateForm cform = new CertificateForm();
				cform.setId(dom.getId());
				model.addAttribute("certificateForm",cform);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			try {
				
				AnchorForm aform = new AnchorForm();
				aform.setId(dom.getId());
				model.addAttribute("anchorForm",aform);
				
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
			SimpleForm simple = new SimpleForm();
			simple.setId(Long.parseLong(strid));
			model.addAttribute("simpleForm",simple);

			model.addAttribute("addressesResults", dom.getAddresses());
			mav.setViewName("domain"); 
			// the Form's default button action
			String action = "Update";
			DomainForm form = (DomainForm) session.getAttribute("domainForm");
			if (form == null) {
				form = new DomainForm();
				form.populate(dom);
			}
			model.addAttribute("domainForm", form);
			model.addAttribute("action", action);
			model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
	
			mav.addObject("statusList", EntityStatus.getEntityStatusList());
		}
		
		AddressForm addressForm2 = new AddressForm();
		
		addressForm2.setDisplayName("");
		addressForm2.setEndpoint("");
		addressForm2.setEmailAddress("");
		addressForm2.setType("");
		addressForm2.setId(Long.parseLong(strid));
		
		model.addAttribute("addressForm",addressForm2);
		
                return new ModelAndView("redirect:/config/domain?id="+anchorForm.getId()+"#tab2");
		//return mav;
	}			
	
	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/removeanchors", method = RequestMethod.POST)
	public ModelAndView removeAnchors (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute AnchorForm simpleForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath)  { 		

		ModelAndView mav = new ModelAndView(); 
	
		if (log.isDebugEnabled()) log.debug("Enter domain/removeanchor");
		if(simpleForm.getRemove() != null){
			if (log.isDebugEnabled()) log.debug("the list of checkboxes checked or not is: "+simpleForm.getRemove().toString());
		}
		
		String strid = ""+simpleForm.getId();
		Domain dom = configSvc.getDomain(Long.parseLong(strid));
		String owner = "";
		String domname = "";
		if( dom != null){
			domname = dom.getDomainName();
			owner = domname;
		}
		if (configSvc != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteanchors") || actionPath.equalsIgnoreCase("Remove Selected Anchors")) && simpleForm.getRemove() != null) {
			int cnt = simpleForm.getRemove().size();
			if (log.isDebugEnabled()) log.debug("removing anchors for domain with name: " + domname);
			try{
				// get list of certificates for this domain
				Collection<Anchor> certs = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
				ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
				// now iterate over each one and remove the appropriate ones
				for (int x = 0; x < cnt; x++) {
					String removeid = simpleForm.getRemove().get(x);
					for (Iterator iter = certs.iterator(); iter.hasNext();) {
						Anchor t = (Anchor) iter.next();
						   //rest of the code block removed
				    	if(t.getId() == Long.parseLong(removeid)){
					    	if (log.isDebugEnabled()){
					    		log.debug(" ");
					    		log.debug("domain address id: " + t.getId());
					    		log.debug(" ");
					    	}
					    	// create a collection of matching anchor ids
					    	certtoberemovedlist.add(t.getId());
					    	break;
				    	}
					}			
				}
				// with the collection of anchor ids now remove them from the configSvc
				if (log.isDebugEnabled()) log.debug(" Trying to remove anchors from database");
				configSvc.removeAnchors(certtoberemovedlist);
	    		if (log.isDebugEnabled()) log.debug(" SUCCESS Trying to update the domain with removed anchors");
				AddressForm addrform = new AddressForm();
				addrform.setId(dom.getId());
				model.addAttribute("addressForm",addrform);
			} catch (ConfigurationServiceException e) {
				if (log.isDebugEnabled())
					log.error(e);
			}
		}
		model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
		// BEGIN: temporary code for mocking purposes
		CertificateForm cform = new CertificateForm();
		cform.setId(dom.getId());
		model.addAttribute("certificateForm",cform);
		
		AnchorForm aform = new AnchorForm();
		aform.setId(dom.getId());
		model.addAttribute("anchorForm",aform);
		
		
		model.addAttribute("addressesResults", dom.getAddresses());
		mav.setViewName("domain"); 
		// the Form's default button action
		String action = "Update";
		DomainForm form = (DomainForm) session.getAttribute("domainForm");
		if (form == null) {
			form = new DomainForm();
			form.populate(dom);
		}
		model.addAttribute("domainForm", form);
		model.addAttribute("action", action);
		model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
		mav.addObject("action", action);

		// SETTING THE ADDRESSES OBJECT
		model.addAttribute("addressesResults", form.getAddresses());
		Collection<Certificate> certlist = null;
		try {
			certlist = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
		} catch (ConfigurationServiceException e) {
			e.printStackTrace();
		}
		
		Collection<Anchor> anchorlist = null;
		try {
			anchorlist = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		model.addAttribute("certificatesResults", certlist);
		// convert Anchor to AnchorForm
		Collection<AnchorForm> convertedanchors = convertAnchors(anchorlist);					
		// now set anchorsResults
		model.addAttribute("anchorsResults", convertedanchors);
		
		// END: temporary code for mocking purposes			
		mav.addObject("statusList", EntityStatus.getEntityStatusList());
		
		model.addAttribute("simpleForm",simpleForm);
		strid = ""+simpleForm.getId();
		if (log.isDebugEnabled()) log.debug(" the value of id of simpleform is: "+strid);
		
		return new ModelAndView("redirect:/config/domain?id="+simpleForm.getId()+"#tab2");
	}			
		
	
	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/addcertificate", method = RequestMethod.POST)
	public ModelAndView addCertificate (
								@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute CertificateForm certificateForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath
						        ) { 		

		ModelAndView mav = new ModelAndView(); 
		String strid = "";
		if (log.isDebugEnabled()) log.debug("Enter domain/addcertificate");
	
		if(actionPath.equalsIgnoreCase("newcertificate") || actionPath.equalsIgnoreCase("add certificate")){
			strid = ""+certificateForm.getId();
			Domain dom = configSvc.getDomain(Long.parseLong(strid));
			String owner = "";
			if(dom != null){
				owner = dom.getPostMasterEmail();
			}
			// insert the new address into the Domain list of Addresses
			EntityStatus estatus = certificateForm.getStatus();
			if (log.isDebugEnabled()) log.debug("beginning to evaluate filedata");		
			try{
				if (!certificateForm.getFileData().isEmpty()) {
					byte[] bytes = certificateForm.getFileData().getBytes();
					owner = certificateForm.getOwner();
					Certificate cert = new Certificate();
					cert.setData(bytes);
					cert.setOwner(owner);
					cert.setStatus(certificateForm.getStatus());

					ArrayList<Certificate> certlist = new ArrayList<Certificate>();
					certlist.add(cert);
					configSvc.addCertificates(certlist);
					// store the bytes somewhere
					if (log.isDebugEnabled()) log.debug("store the certificate into database");
				} else {
					if (log.isDebugEnabled()) log.debug("DO NOT store the certificate into database BECAUSE THERE IS NO FILE");
				}

			} catch (ConfigurationServiceException ed) {
				if (log.isDebugEnabled())
					log.error(ed);
			} catch (Exception e) {
				if (log.isDebugEnabled()) log.error(e);
				e.printStackTrace();
			}
			// certificate and anchor forms and results
			try {
				Collection<Certificate> certs = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
				model.addAttribute("certificatesResults", certs);
				 
				Collection<Anchor> anchors = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
				// convert Anchor to AnchorForm
				Collection<AnchorForm> convertedanchors = convertAnchors(anchors);					
				// now set anchorsResults
				model.addAttribute("anchorsResults", convertedanchors);
				
				CertificateForm cform = new CertificateForm();
				cform.setId(dom.getId());
				model.addAttribute("certificateForm",cform);
				
				AnchorForm aform = new AnchorForm();
				aform.setId(dom.getId());
				model.addAttribute("anchorForm",aform);
				
			} catch (ConfigurationServiceException e1) {
				e1.printStackTrace();
			}
			model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
			SimpleForm simple = new SimpleForm();
			simple.setId(Long.parseLong(strid));
			model.addAttribute("simpleForm",simple);

			model.addAttribute("addressesResults", dom.getAddresses());
			mav.setViewName("domain"); 
			// the Form's default button action
			String action = "Update";
			DomainForm form = (DomainForm) session.getAttribute("domainForm");
			if (form == null) {
				form = new DomainForm();
				form.populate(dom);
			}
			model.addAttribute("domainForm", form);
			model.addAttribute("action", action);
			model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
	
			mav.addObject("statusList", EntityStatus.getEntityStatusList());
		}
		
		AddressForm addressForm2 = new AddressForm();
		
		addressForm2.setDisplayName("");
		addressForm2.setEndpoint("");
		addressForm2.setEmailAddress("");
		addressForm2.setType("");
		addressForm2.setId(Long.parseLong(strid));
		
		model.addAttribute("addressForm",addressForm2);
		
		return mav;
	}		
	
	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/removecertifcates", method = RequestMethod.POST)
	public ModelAndView removeCertificates (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute CertificateForm simpleForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath)  { 		

		ModelAndView mav = new ModelAndView(); 
	
		if (log.isDebugEnabled()) log.debug("Enter domain/removecertificates");
		if(simpleForm.getRemove() != null){
			if (log.isDebugEnabled()) log.debug("the list of checkboxes checked or not is: "+simpleForm.getRemove().toString());
		}
		
		String strid = ""+simpleForm.getId();
		Domain dom = configSvc.getDomain(Long.parseLong(strid));
		String owner = "";
		String domname = "";
		if( dom != null){
			domname = dom.getPostMasterEmail();
			owner = domname;
		}
		if (configSvc != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deletecertificate") || actionPath.equalsIgnoreCase("remove selected")) && simpleForm.getRemove() != null) {
			int cnt = simpleForm.getRemove().size();
			if (log.isDebugEnabled()) log.debug("removing certificates for domain with name: " + domname);
			try{
				// get list of certificates for this domain
				Collection<Certificate> certs = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
				ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
				// now iterate over each one and remove the appropriate ones
				for (int x = 0; x < cnt; x++) {
					String removeid = simpleForm.getRemove().get(x);
					for (Iterator iter = certs.iterator(); iter.hasNext();) {
						   Certificate t = (Certificate) iter.next();
						   //rest of the code block removed
				    	if(t.getId() == Long.parseLong(removeid)){
					    	if (log.isDebugEnabled()){
					    		log.debug(" ");
					    		log.debug("domain address id: " + t.getId());
					    		log.debug(" ");
					    	}
					    	// create a collection of matching anchor ids
					    	certtoberemovedlist.add(t.getId());
					    	break;
				    	}
					}			
				}
				// with the collection of anchor ids now remove them from the configSvc
				if (log.isDebugEnabled()) log.debug(" Trying to remove certificates from database");
				configSvc.removeCertificates(certtoberemovedlist);
	    		if (log.isDebugEnabled()) log.debug(" SUCCESS Trying to update the domain with removed certificates");
				AddressForm addrform = new AddressForm();
				addrform.setId(dom.getId());
				model.addAttribute("addressForm",addrform);
			} catch (ConfigurationServiceException e) {
				if (log.isDebugEnabled())
					log.error(e);
			}
		}
		model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
		// BEGIN: temporary code for mocking purposes
		CertificateForm cform = new CertificateForm();
		cform.setId(dom.getId());
		model.addAttribute("certificateForm",cform);
		
		AnchorForm aform = new AnchorForm();
		aform.setId(dom.getId());
		model.addAttribute("anchorForm",aform);
		
		
		model.addAttribute("addressesResults", dom.getAddresses());
		mav.setViewName("domain"); 
		// the Form's default button action
		String action = "Update";
		DomainForm form = (DomainForm) session.getAttribute("domainForm");
		if (form == null) {
			form = new DomainForm();
			form.populate(dom);
		}
		model.addAttribute("domainForm", form);
		model.addAttribute("action", action);
		model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
		mav.addObject("action", action);

		// SETTING THE ADDRESSES OBJECT
		model.addAttribute("addressesResults", form.getAddresses());
		Collection<Certificate> certlist = null;
		try {
			certlist = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
		} catch (ConfigurationServiceException e) {
			e.printStackTrace();
		}
		
		Collection<Anchor> anchorlist = null;
		try {
			anchorlist = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		model.addAttribute("certificatesResults", certlist);
		// convert Anchor to AnchorForm
		Collection<AnchorForm> convertedanchors = convertAnchors(anchorlist);					
		// now set anchorsResults
		model.addAttribute("anchorsResults", convertedanchors);
		
		// END: temporary code for mocking purposes			
		mav.addObject("statusList", EntityStatus.getEntityStatusList());

		model.addAttribute("simpleForm",simpleForm);
	    strid = ""+simpleForm.getId();
		if (log.isDebugEnabled()) log.debug(" the value of id of simpleform is: "+strid);
		
		return mav;
	}			
	
	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/addaddress", method = RequestMethod.POST)
	public ModelAndView addAddress (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute AddressForm addressForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath) { 		

		ModelAndView mav = new ModelAndView(); 
		String strid = "";
		if (log.isDebugEnabled()) log.debug("Enter domain/addaddress");
		
		if(actionPath.equalsIgnoreCase("newaddress") || actionPath.equalsIgnoreCase("add address")){
			strid = ""+addressForm.getId();
			Domain dom = configSvc.getDomain(Long.parseLong(strid));
			String owner = dom.getPostMasterEmail();
			// insert the new address into the Domain list of Addresses
			String anEmail = addressForm.getEmailAddress();
			String displayname = addressForm.getDisplayName();
			String endpoint = addressForm.getEndpoint();
			EntityStatus estatus = addressForm.getaStatus();
			String etype = addressForm.getType();
			
			if (log.isDebugEnabled()) log.debug(" Trying to add address: "+anEmail);
			Address e = new Address();
			e.setEmailAddress(anEmail);
			e.setDisplayName(displayname);
			e.setEndpoint(endpoint);
			e.setStatus(estatus);
			e.setType(etype);
			
			dom.getAddresses().add(e);
			
			try{
			    configSvc.updateDomain(dom);
				if (log.isDebugEnabled()) log.debug(" After attempt to insert new email address ");
			} catch (ConfigurationServiceException ed) {
				if (log.isDebugEnabled())
					log.error(ed);
			}
			// certificate and anchor forms and results
			try {
				Collection<Certificate> certs = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
				model.addAttribute("certificatesResults", certs);
			} catch (ConfigurationServiceException e1) {
			}
				 
			try {
				Collection<Anchor> anchors = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
				// convert Anchor to AnchorForm
				Collection<AnchorForm> convertedanchors = convertAnchors(anchors);					
				// now set anchorsResults
				model.addAttribute("anchorsResults", convertedanchors);
			} catch (Exception e1) {
			}
				
			try {
				CertificateForm cform = new CertificateForm();
				cform.setId(dom.getId());
				model.addAttribute("certificateForm",cform);
				
				AnchorForm aform = new AnchorForm();
				aform.setId(dom.getId());
				model.addAttribute("anchorForm",aform);
				
			} catch (Exception e1x) {
			}
			model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
			SimpleForm simple = new SimpleForm();
			simple.setId(Long.parseLong(strid));
			model.addAttribute("simpleForm",simple);

			model.addAttribute("addressesResults", dom.getAddresses());
			mav.setViewName("domain"); 
			// the Form's default button action
			String action = "Update";
			DomainForm form = (DomainForm) session.getAttribute("domainForm");
			if (form == null) {
				form = new DomainForm();
				form.populate(dom);
			}
			model.addAttribute("domainForm", form);
			model.addAttribute("action", action);
			model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
	
			mav.addObject("statusList", EntityStatus.getEntityStatusList());
		}
		
		AddressForm addressForm2 = new AddressForm();
		
		addressForm2.setDisplayName("");
		addressForm2.setEndpoint("");
		addressForm2.setEmailAddress("");
		addressForm2.setType("");
		addressForm2.setId(Long.parseLong(strid));
		
		model.addAttribute("addressForm",addressForm2);
		
		return mav;
	}		
	
	@PreAuthorize("hasRole('ROLE_ADMIN')")
	@RequestMapping(value="/removeaddresses", method = RequestMethod.POST)
	public ModelAndView removeAddresses (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute SimpleForm simpleForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath)  { 		

		ModelAndView mav = new ModelAndView(); 
	
		if (log.isDebugEnabled()) log.debug("Enter domain/removeaddresses");
		if(simpleForm.getRemove() != null){
			if (log.isDebugEnabled()) log.debug("the list of checkboxes checked or not is: "+simpleForm.getRemove().toString());
		}
		
		String strid = ""+simpleForm.getId();
		Domain dom = configSvc.getDomain(Long.parseLong(strid));
		String domname = "";
		if (dom != null) {
			domname = dom.getDomainName();
			if (configSvc != null
					&& simpleForm != null
					&& actionPath != null
					&& (actionPath.equalsIgnoreCase("delete") || actionPath
							.equalsIgnoreCase("remove selected Addresses"))
					&& simpleForm.getRemove() != null) {
				int cnt = simpleForm.getRemove().size();
				if (log.isDebugEnabled())
					log.debug("removing addresses for domain with name: "
							+ domname);
				try {
					
					for (int x = 0; x < cnt; x++) {
						String removeid = simpleForm.getRemove().get(x);
						System.out.println("TRYING TO REMOVE ID: "+removeid);
						Collection<Address> t = dom.getAddresses();
						for (Iterator iter = t.iterator(); iter.hasNext();) {
							Address ts = (Address) iter.next();
							if (ts.getId() == Long.parseLong(removeid)) {
								dom.getAddresses().remove(ts);
								if (configSvc != null) {
									configSvc.removeAddress(ts.getEmailAddress());
									dom = configSvc.getDomain(Long.parseLong(strid));
									break;
								}
							}
						}
					}
					if (log.isDebugEnabled())
						log
								.debug(" Trying to update the domain with removed addresses");
					configSvc.updateDomain(dom);
					dom = configSvc.getDomain(Long.parseLong(strid));
					if (log.isDebugEnabled())
						log
								.debug(" SUCCESS Trying to update the domain with removed addresses");
					AddressForm addrform = new AddressForm();
					addrform.setId(dom.getId());
					model.addAttribute("addressForm", addrform);
					// BEGIN: temporary code for mocking purposes
					String owner = "";
					owner = dom.getPostMasterEmail();
					model.addAttribute("addressesResults", dom.getAddresses());

					Collection<Certificate> certlist = null;
					try {
						certlist = configSvc.getCertificatesForOwner(owner,
								CertificateGetOptions.DEFAULT);
					} catch (ConfigurationServiceException e) {
						e.printStackTrace();
					}

					Collection<Anchor> anchorlist = null;
					try {
						anchorlist = configSvc.getAnchorsForOwner(owner,CertificateGetOptions.DEFAULT);
					} catch (Exception e) {
						
					}

					model.addAttribute("certificatesResults", certlist);
					// convert Anchor to AnchorForm
					Collection<AnchorForm> convertedanchors = convertAnchors(anchorlist);
					// now set anchorsResults
					model.addAttribute("anchorsResults", convertedanchors);

					// END: temporary code for mocking purposes

				} catch (ConfigurationServiceException e) {
					if (log.isDebugEnabled())
						log.error(e);
				}
			} else if (configSvc != null
					&& (actionPath.equalsIgnoreCase("newaddress") || actionPath
							.equalsIgnoreCase("add address"))) {
				// insert the new address into the Domain list of Addresses
				String anEmail = simpleForm.getPostmasterEmail();
				if (log.isDebugEnabled())
					log.debug(" Trying to add address: " + anEmail);
				Address e = new Address();
				e.setEmailAddress(anEmail);
				dom.getAddresses().add(e);
				simpleForm.setPostmasterEmail("");
				try {
					configSvc.updateDomain(dom);
					if (log.isDebugEnabled())
						log
								.debug(" After attempt to insert new email address ");
				} catch (ConfigurationServiceException ed) {
					if (log.isDebugEnabled())
						log.error(ed);
				}
			}
		}

		model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
		mav.addObject("statusList", EntityStatus.getEntityStatusList());
		String action = "Update";
		model.addAttribute("action", action);			
		DomainForm form = (DomainForm) session.getAttribute("domainForm");
		if (form == null) {
			form = new DomainForm();
			form.populate(dom);
		}
		model.addAttribute("domainForm", form);
		mav.setViewName("domain");
		String owner = dom.getPostMasterEmail();
		// certificate and anchor forms and results
		try {
			if(owner != null && !owner.equalsIgnoreCase("")){
				Collection<Certificate> certs = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
				model.addAttribute("certificatesResults", certs);
				 
				Collection<Anchor> anchors = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
				// convert Anchor to AnchorForm
				Collection<AnchorForm> convertedanchors = convertAnchors(anchors);					
				// now set anchorsResults
				model.addAttribute("anchorsResults", convertedanchors);
			}
			
			CertificateForm cform = new CertificateForm();
			cform.setId(dom.getId());
			model.addAttribute("certificateForm",cform);
			
			AnchorForm aform = new AnchorForm();
			aform.setId(dom.getId());
			model.addAttribute("anchorForm",aform);
			
		} catch (ConfigurationServiceException e1) {
			e1.printStackTrace();
		}
			
		model.addAttribute("simpleForm",simpleForm);
		strid = ""+simpleForm.getId();
		if (log.isDebugEnabled()) log.debug(" the value of id of simpleform is: "+strid);
		 
		return mav;
	}		
	
        
        /**  removeDomain
        * 
        * 
        * 
        * 
        */        
	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(value="/remove", method = RequestMethod.POST)
	public ModelAndView removeDomain (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
						        HttpSession session,
						        @ModelAttribute SimpleForm simpleForm,
						        Model model,
						        @RequestParam(value="submitType") String actionPath)  { 		

		ModelAndView mav = new ModelAndView(); 
	
		if (log.isDebugEnabled()) log.debug("Enter domain/remove");
		if (log.isDebugEnabled()) log.debug("the list of checkboxes checked or not is: "+simpleForm.getRemove().toString());
		
		if (configSvc != null) 
                {
                    int cnt = simpleForm.getRemove().size();
                    for (int x = 0; x < cnt; x++) {
                        try 
                        {
                            String strid = simpleForm.getRemove().get(x);
                            Long domainId = Long.parseLong(strid);
                            Domain dom = configSvc.getDomain(domainId);
                            
                            if(dom != null) {
                                String owner = dom.getDomainName();
                            
                                //String domname = dom.getDomainName();

                                if (log.isDebugEnabled()) log.debug("removing domain with id: " + domainId);

                                configSvc.removeDomainById(domainId);

                                // now delete anchors
                                try{
                                        // get list of certificates for this domain
                                        Collection<Anchor> certs = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                                        if (certs != null) {
                                                ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
                                                // now iterate over each one and remove the
                                                // appropriate ones
                                                for (Iterator iter = certs.iterator(); iter
                                                                .hasNext();) {
                                                        Anchor t = (Anchor) iter.next();
                                                        certtoberemovedlist.add(t.getId());
                                                }
                                                // with the collection of anchor ids now remove them
                                                // from the configSvc
                                                if (log.isDebugEnabled())
                                                        log
                                                                        .debug(" Trying to remove anchors from database");
                                                configSvc.removeAnchors(certtoberemovedlist);
                                                if (log.isDebugEnabled())
                                                        log.debug(" SUCCESS Trying to remove anchors");

                                        }
                                } catch (ConfigurationServiceException e) {
                                        if (log.isDebugEnabled())
                                                log.error(e);
                                }
                            
                            }
                            
                        } catch (ConfigurationServiceException e) {
                                if (log.isDebugEnabled())
                                        log.error(e);
                        }
                        
                    }
		}
		SearchDomainForm form2 = (SearchDomainForm) session.getAttribute("searchDomainForm");
		model.addAttribute(form2 != null ? form2 : new SearchDomainForm());
		model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));

		// Get all domains managed by this HISP
                String domain = "%";
                

                List<Domain> results = null;

                if (configSvc != null) 
                {
                    
                    List<Domain> domains = new ArrayList<Domain>();
                    
                    Collection<Domain> enabledDomains = configSvc.searchDomain(domain,EntityStatus.ENABLED);
                    Collection<Domain> disabledDomains = configSvc.searchDomain(domain,EntityStatus.DISABLED);                    
                    Collection<Domain> newDomains = configSvc.searchDomain(domain,EntityStatus.NEW);
                    
                    if(enabledDomains != null) 
                    {
                        domains.addAll(enabledDomains);
                    }
                    
                    if(disabledDomains != null)
                    {
                        domains.addAll(disabledDomains);
                    }                    
                    
                    if (newDomains != null)
                    {
                        domains.addAll(newDomains);
                        
                    }
                    
                    results = domains;
                }
                
                model.addAttribute("searchResults", results);

                mav.setViewName("main");
                mav.addObject("statusList", EntityStatus.getEntityStatusList());
                mav.addObject("searchResults", results);
                
		mav.addObject("statusList", EntityStatus.getEntityStatusList());
		
		return mav;
	}	
	
        
        
        
        

	@PreAuthorize("hasRole('ROLE_ADMIN')") 
	@RequestMapping(method = RequestMethod.POST)
	public ModelAndView onSubmitAndView(Object command){
		if (log.isDebugEnabled()) log.debug("Enter onSubmit");
		return new ModelAndView(new RedirectView("main"));
	}
	
    @RequestMapping(value = "/simpleForm", method = RequestMethod.GET)
    public void simpleForm(Model model) {
            model.addAttribute(new SimpleForm());
    }	
    
    
    @PreAuthorize("hasRole('ROLE_ADMIN')") 
    @RequestMapping(value="/updateBundleDirection", method = RequestMethod.POST)
    public ModelAndView updateBundleDirection (@RequestHeader(value="X-Requested-With", required=false) String requestedWith,         
        @RequestParam(required=true) String domainId,
        @RequestParam(required=true) String bundle,
        @RequestParam(required=true) String direction,
        @RequestParam(required=true) String directionValue,
                                                    HttpSession session, Model model)  { 
        
        Long id = Long.parseLong(domainId);
        
        Collection<TrustBundleDomainReltn> bundles = null;
        
        try {
            bundles = configSvc.getTrustBundlesByDomain(id, false);
        } catch (ConfigurationServiceException ex) {
            Logger.getLogger(DomainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        for(TrustBundleDomainReltn bundleReltn : bundles) {
            if(bundleReltn.getId() == Long.parseLong(bundle)) {
                if(direction.toLowerCase().equals("incoming"))
                {
                    if(Integer.parseInt(directionValue) == 1) {
                        bundleReltn.setIncoming(true); 
                    } else {
                        bundleReltn.setIncoming(false);                        
                    }
                } else {
                    if(Integer.parseInt(directionValue) == 1) {
                        bundleReltn.setOutgoing(true); 
                    } else {
                        bundleReltn.setOutgoing(false);
                    }
                }
                
            }
        }
        
        
        
        ModelAndView mav = new ModelAndView(); 
        
        mav.setViewName("updateBundleDirection");
        
        return mav;
    }
    
    
    
    /**
     * Display a Domain
     */
    @RequestMapping(method=RequestMethod.GET)
    public ModelAndView viewDomain (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 
                                                            @RequestParam(required=false) String id,
                                                            HttpSession session, 
                                                            Model model) throws java.security.cert.CertificateException { 		
            if (log.isDebugEnabled()) {
                log.debug("Enter View Domain");
            }		
            
            ModelAndView mav = new ModelAndView(); 

            mav.setViewName("domain"); 

            String action = "Add";

            DomainForm form = (DomainForm) session.getAttribute("domainForm");
            
            if (form == null) {
                    form = new DomainForm();
            }
            
            model.addAttribute("domainForm", form);
            model.addAttribute("action", action);
            model.addAttribute("ajaxRequest", AjaxUtils.isAjaxRequest(requestedWith));
            

            mav.addObject("action", action);
            mav.addObject("statusList", EntityStatus.getEntityStatusList());

            if ((id != null) && (id.length() > 0)) 
            {
                if (log.isDebugEnabled()) {
                    log.debug("Need to search for Domain ID: " + id);
                }		

                Domain results = null;
                Long dId = Long.decode(id);
                model.addAttribute("domainId", dId);

                AddressForm addrform = new AddressForm();
                addrform.setId(dId);
                model.addAttribute("addressForm",addrform);

                CertificateForm cform = new CertificateForm();
                cform.setId(dId);
                AnchorForm aform = new AnchorForm();
                aform.setId(dId);

                model.addAttribute("certificateForm",cform);
                model.addAttribute("anchorForm",aform);
                
                if (configSvc != null) {
                        results = configSvc.getDomain(dId);
                                                
                        if (results != null) {
                            
                                if (log.isDebugEnabled()) {
                                    log.debug("Found a valid domain" + results.toString());
                                }		
                                
                                Collection<TrustBundleDomainReltn> bundles = null;
                                
                                // Get Trust Bundles
                                try {
                                    bundles = configSvc.getTrustBundlesByDomain(dId, true);
                                } catch (ConfigurationServiceException cse) {
                                    
                                }
                                
                                if(bundles != null) {
                                
                                    model.addAttribute("trustBundles", bundles);                                                                        
                                    
                                    Map<String, Object> bundleMap = new HashMap<String, Object>(bundles.size());                                                                                                            
                                    
                                    Collection<TrustBundleAnchor> tbAnchors;    // Store anchors for each bundle   
                                                                        

                                    for(TrustBundleDomainReltn bundle : bundles) 
                                    {                                        
                                        tbAnchors = bundle.getTrustBundle().getTrustBundleAnchors();    
                                        Map<TrustBundleAnchor, String> anchorMap = new HashMap<TrustBundleAnchor, String>(tbAnchors.size());                                                                                
                                        
                                        //String[] anchorDNs = new String[tbAnchors.size()];  // String array for storing anchor DNs
                                        int curAnchor = 0;  // Counter as we iterate through anchor list
                                        
                                        // Loop through anchors to collect some information about the certificates
                                        for(TrustBundleAnchor anchor : tbAnchors) {
                                             
                                            try {
                                                X509Certificate cert = anchor.toCertificate();                                            
                                           
                                                String subjectDN = cert.getSubjectDN().toString();
                                                anchorMap.put(anchor, subjectDN);
                                                                                                                                                        
                                            } catch (CertificateException ex) {                                                
                                            }
                                            
                                            curAnchor++;
                                        }
                                                                                                                                                               
                                        bundleMap.put(bundle.getTrustBundle().getBundleName(), anchorMap);
                                                                                
                                    }
                                    
                                    model.addAttribute("bundleMap", bundleMap);
                                }
                                
                                form.populate(results);
                                action = "Update";
                                model.addAttribute("action", action);
                                
                                // SETTING THE ADDRESSES OBJECT
                                model.addAttribute("addressesResults", results.getAddresses());

                                // BEGIN: temporary code for mocking purposes
                                String owner = "";
                                owner = results.getDomainName();
                                model.addAttribute("addressesResults", results.getAddresses());
                                Collection<Certificate> certlist = null;
                                try {
                                        certlist = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                                } catch (ConfigurationServiceException e) {
                                        e.printStackTrace();
                                }

                                Collection<Anchor> anchorlist = null;
                                try {
                                        anchorlist = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                                } catch (ConfigurationServiceException e) {
                                        e.printStackTrace();
                                }

                                model.addAttribute("certificatesResults", certlist);

                                // convert Anchor to AnchorForm
                                Collection<AnchorForm> convertedanchors = convertAnchors(anchorlist);					
                                // now set anchorsResults
                                model.addAttribute("anchorsResults", convertedanchors);

                                // END: temporary code for mocking purposes			

                                SimpleForm simple = new SimpleForm();
                                simple.setId(dId);
                                model.addAttribute("simpleForm",simple);
                                mav.addObject("action", action);
                        }
                        else {
                                log.warn("Service returned a null Domain for a known key: " + dId);		
                        }
                }
                else { 
                        log.error("Web Service bean is null.  Configuration error detected.");		
                }
                
                if (AjaxUtils.isAjaxRequest(requestedWith)) {
                        // prepare model for rendering success message in this request
                        model.addAttribute("message", "");
                        model.addAttribute("ajaxRequest", true);
                        model.addAttribute("action", action);
                        return null;
                }
            }

            if (log.isDebugEnabled()) log.debug("Exit");
            return mav;
    }
	
	/**
	 * Execute the save and return the results
	 */
	@PreAuthorize("hasRole('ROLE_ADMIN')")
	@RequestMapping(value="/saveupdate", method=RequestMethod.POST )
	public ModelAndView saveDomain (@RequestHeader(value="X-Requested-With", required=false) String requestedWith, 							   
								HttpSession session, 
								@RequestParam(value="submitType") String actionPath,
							        @ModelAttribute("domainForm") DomainForm form,
							        Model model)  
        { 		
		if (log.isDebugEnabled()) log.debug("Enter");
		if (log.isDebugEnabled()) log.debug("Entered saveDomain");
		if (log.isDebugEnabled()) log.debug("The value of actionPath: "+actionPath);
		
                ModelAndView mav = new ModelAndView(); 
		
                if (actionPath.equalsIgnoreCase("cancel")) {
			
                    if (log.isDebugEnabled()) 
                    {
                        log.debug("trying to cancel from saveupdate");
                    }			                    
                    
                    return new ModelAndView("redirect:/config/main");
                    
		} else if ((actionPath.equalsIgnoreCase("update") || actionPath.equalsIgnoreCase("add"))) {
                    
                    HashMap<String, String> msgs = new HashMap<String, String>();
                    
                    mav.addObject("msgs", msgs);

                    mav.setViewName("domain");

                    try {
                        
                        if (actionPath.equalsIgnoreCase("add")) {
                            
                            // Add domain to configuration service
                            configSvc.addDomain(form.getDomainFromForm());
                            
                            List<Domain> result = new ArrayList<Domain>(configSvc.searchDomain(form.getDomainName(), form.getStatus()));
                            
                            if(form.getSelectedBundles() != "") {                                                                
                            
                                // Associate trust bundles if selected
                                String selBundle = form.getSelectedBundles();
                                String[] bundles = selBundle.split(",");

                                int bundleCount = bundles.length;

                                log.debug("# of bundles associated: "+bundleCount);

                                // Associate trust bundles to Domain
                                for(int i=0; i<bundleCount; i++) {                                
                                    /*
                                     * TODO: Add  incoming and outgoing indicators
                                     */
                                    String[] bundleString = bundles[i].split("_");
                                    
                                    if(bundleString[1].equals("both")) {
                                        configSvc.associateTrustBundleToDomain(result.get(0).getId(), Integer.parseInt(bundleString[0]), true, true);
                                    } else if (bundleString[1].equals("in")) {
                                        configSvc.associateTrustBundleToDomain(result.get(0).getId(), Integer.parseInt(bundleString[0]), true, false);
                                    } else if (bundleString[1].equals("out")) {
                                        configSvc.associateTrustBundleToDomain(result.get(0).getId(), Integer.parseInt(bundleString[0]), false, true);
                                    } else {
                                        configSvc.associateTrustBundleToDomain(result.get(0).getId(), Integer.parseInt(bundleString[0]), false, false);
                                    }
                                    
                                    log.error("Added Bundle ID #"+bundles[i]);
                                }   
                            }
                            
                            if (result.size() > 0) {
                                    form = new DomainForm();
                                    form.populate(result.get(0));
                                    msgs.put("msg", "domain.add.success");
                            }
                            
                        } else if (actionPath.equalsIgnoreCase("update")) {
                            
                            configSvc.updateDomain(form.getDomainFromForm());
                            
                            List<Domain> result = new ArrayList<Domain>(configSvc.searchDomain(form.getDomainName(), form.getStatus()));
                            
                            if (result.size() > 0) {
                                    form = new DomainForm();
                                    form.populate(result.get(0));
                            }
                            
                            msgs.put("msg", "domain.update.success");
                        }

                        AddressForm addrform = new AddressForm();
                        addrform.setId(form.getDomainFromForm().getId());
                        model.addAttribute("domainForm",form);
                        model.addAttribute("addressForm",addrform);

                        CertificateForm cform = new CertificateForm();
                        cform.setId(form.getDomainFromForm().getId());
                        AnchorForm aform = new AnchorForm();
                        aform.setId(form.getDomainFromForm().getId());

                        model.addAttribute("certificateForm",cform);
                        model.addAttribute("anchorForm",aform);
                        
                        SimpleForm simple = new SimpleForm();
                        simple.setId(form.getDomainFromForm().getId());
                        model.addAttribute("simpleForm",simple);

                        // once certificates and anchors are available change code accordingly
                        // begin: add these dummy records too
                        String owner = form.getDomainFromForm().getPostMasterEmail();

                        try {
                            if(owner != null && !owner.equalsIgnoreCase("")){
                                // BEGIN: temporary code for mocking purposes
                                Collection<Certificate> certlist = null;
                                try {
                                        certlist = configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                                        model.addAttribute("certificatesResults", certlist);

                                } catch (ConfigurationServiceException e) {
                                        e.printStackTrace();
                                }

                                Collection<Anchor> anchorlist = null;
                                anchorlist = configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                                // convert Anchor to AnchorForm
                                Collection<AnchorForm> convertedanchors = convertAnchors(anchorlist);
                                // now set anchorsResults
                                model.addAttribute("anchorsResults", convertedanchors);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }


                        
                        
                        
                        
                        // END: temporary code for mocking purposes			


                        //  end: add these dummy records too
                        model.addAttribute("addressesResults", form.getDomainFromForm().getAddresses());

                        model.addAttribute("action", "update");
                        if (log.isDebugEnabled()) {
                            log.debug("Stored domain: " + form.getDomainFromForm().toString());
                        }
                                

                    } catch (ConfigurationServiceException e) {
                            log.error(e);
                            msgs.put("domainService", "domainService.add.error");
                    }catch(Exception ed){
                            log.error(ed);
                    }
		}
		if (log.isDebugEnabled()) log.debug("Exit");
		
                return new ModelAndView("redirect:/config/domain?id="+form.getId());
                //return mav;
	}
	
	/**
	 * Handle exceptions as gracefully as possible
	 * @param ex
	 * @param request
	 * @return
	 */
	@ExceptionHandler(IOException.class) 
	public String handleIOException(IOException ex, HttpServletRequest request) {
		return ClassUtils.getShortName(ex.getClass() + ":" + ex.getMessage());
	}

	public void setConfigSvc(ConfigurationService service) {
		this.configSvc = service;
	}

	
    public CertContainer toCertContainer(byte[] data) throws Exception
    {
        CertContainer certContainer = null;
        try
        {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);

            // lets try this a as a PKCS12 data stream first
            try
            {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", Certificate.getJCEProviderName());

                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();


                        // we are really expecting only one alias
                        if (aliases.hasMoreElements())
                        {
                                String alias = aliases.nextElement();
                                X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);

                                // check if there is private key
                                Key key = localKeyStore.getKey(alias, "".toCharArray());
                                if (key != null && key instanceof PrivateKey)
                                {
                                        certContainer = new CertContainer(cert, key);

                                }
                        }
            }
            catch (Exception e)
            {
                // must not be a PKCS12 stream, go on to next step
            }

            if (certContainer == null)
            {
                //try X509 certificate factory next
                bais.reset();
                bais = new ByteArrayInputStream(data);

                X509Certificate cert = (X509Certificate) CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e)
        {
            throw new ConfigurationServiceException("Data cannot be converted to a valid X.509 Certificate", e);
        }

        return certContainer;
    }

    public static class CertContainer
    {
                private final X509Certificate cert;
        private final Key key;

        public CertContainer(X509Certificate cert, Key key)
        {
                this.cert = cert;
                this.key = key;
        }

        public X509Certificate getCert()
        {
                        return cert;
                }

                public Key getKey()
                {
                        return key;
                }

    }

    private String getTrustedEntityName(X500Principal prin)
    {
    	// check the CN attribute first
    	
    	
        // get the domain name
                Map<String, String> oidMap = new HashMap<String, String>();
                oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");  // OID for email address
                String prinName = prin.getName(X500Principal.RFC1779, oidMap);

                
                String searchString = "CN=";
                int index = prinName.indexOf(searchString);
                if (index == -1)
                {
                        searchString = "EMAILADDRESS=";
                        // fall back to email
                        index = prinName.indexOf(searchString);
                        if (index == -1)
                                return ""; // no CN... nothing else that can be done from here
                }

                // look for a "," to find the end of this attribute
                int endIndex = prinName.indexOf(",", index);
                String address;
                if (endIndex > -1)
                        address = prinName.substring(index + searchString.length(), endIndex);
                else
                        address= prinName.substring(index + searchString.length());

                return address;
    }
}
